#include <Arduino.h>
#include <WiFi.h>
#include <HTTPClient.h>
#include <DHT.h>

const char* ssid = "DESKTOP-EQDBAC4 8790";
const char* password = "-041nP48";
const char* server = "http://192.168.137.1:5000/data";

#define DHTPIN 27
#define DHTTYPE DHT22
DHT dht(DHTPIN, DHTTYPE);

#define LED_PIN 13
#define BUZZER_PIN 14
#define RAIN_SENSOR_PIN 26
void setup() {
  Serial.begin(115200);
  dht.begin();

  pinMode(LED_PIN, OUTPUT);
  pinMode(BUZZER_PIN, OUTPUT);
  pinMode(RAIN_SENSOR_PIN, INPUT);

  WiFi.begin(ssid, password);
  Serial.print("Conectare WiFi");
  while (WiFi.status() != WL_CONNECTED) {
    delay(500); Serial.print(".");
  }
  Serial.println("\nConectat la WiFi!");
}

void alerta() {
  for (int i = 0; i < 10; i++) {
    digitalWrite(LED_PIN, HIGH);
    tone(BUZZER_PIN, 1000);
    delay(200);
    digitalWrite(LED_PIN, LOW);
    tone(BUZZER_PIN, 1500);
    delay(200);
  }
  noTone(BUZZER_PIN);
}

void loop() {
  float temp = dht.readTemperature();
  float hum = dht.readHumidity();
  int rain_detected = digitalRead(RAIN_SENSOR_PIN) == LOW;  // LOW = detectie apa

  if (isnan(temp) || isnan(hum)) {
    Serial.println("Eroare senzor DHT");
    delay(2000);
    return;
  }

  int storm_risk = 0;
  if (temp < 10) storm_risk += 40;
  if (hum > 70) storm_risk += 40;
  if (rain_detected) storm_risk += 20;

  Serial.printf("Temp: %.1f°C, Umid: %.1f%%, Ploaie: %s, Risc: %d%%\n",
                temp, hum, rain_detected ? "DA" : "NU", storm_risk);

  if (storm_risk >= 60) {
    alerta();
  } else {
    digitalWrite(LED_PIN, LOW);
    digitalWrite(BUZZER_PIN, LOW);
  }

  if (WiFi.status() == WL_CONNECTED) {
    HTTPClient http;
    http.begin(server);
    http.addHeader("Content-Type", "application/json");

    String payload = "{\"temp\":" + String(temp) +
                     ",\"hum\":" + String(hum) +
                     ",\"rain_detected\":" + String(rain_detected) +
                     ",\"risk\":" + String(storm_risk) + "}";

    int status = http.POST(payload);
    Serial.print("Status POST: "); Serial.println(status);
    http.end();
  }

  delay(5000);
}
